# Antivirus Server Kit

This Docker Compose set up demonstrates how to run an Antivirus Server.  

It uses two containers:

- The first is an Antivirus REST server (`antivirus`) produced by Cloud CMS.
- The other is an open source ClamAV Daemon server (`clamav`).

There are many ClavAV Daemon server containers out there.  We chose one here that we feel was well maintained and
also offers automatic updating of the virus definitions database.

The `antivirus` container exposes a simple HTTP API and connects to the `clamav` container over a TCP port.
The HTTP API runs on port 80 by default.  

When files are submitted to the HTTP API, they are scanned using ClamAV.

You should configure the `antivirus.env` file according to your needs.  The `username` and `password` must match
what you put into the Cloud CMS API's `docker.properties`.

For more information see:

- https://www.cloudcms.com/documentation/antivirus.html
- https://www.cloudcms.com/documentation/docker/configuration/antivirus-server.html
- https://www.cloudcms.com/documentation/docker/configuration/api-server.html#antivirus-scanning
