$(document).ready(function() {

    Gitana.connect({
        "cookie": true
    }, function(err) {
        
        var user = this.getDriver().getAuthInfo().user;
        
        var name = user.name;
        if (user.firstName && user.lastName)
        {
            name = user.firstName + " " + user.lastName;
        }
        
        $(".username").append(name);        
        
        this.listRepositories().keepOne().listBranches().keepOne().queryNodes({
            "_type": "n:node"
        }, {
            "limit": 10,
            "skip": 0,
        }).each(function() {                
            $(".documents").append("<div>" + this.getTitle() + "</div>");                
        });
    });   
    
    $(".logout").click(function() {
        Gitana.deleteCookie("GITANA_TICKET");
    });

});
