var server = require("cloudcms-server/server");

server.report(function(callback) {

    console.log("Web Server: http://localhost:" + process.env.PORT);
    console.log("");

    callback();
});

/**
 * Start the Server
 */
server.start({
    "setup": "single",
    "welcome": {
        "enabled": true,
        "file": "index.html"
    },
    "session": {
        "enabled": true,
        "type": "memory"
    },
    "auth": {
        "enabled": true,
        "providers": {
            "facebook1": {
                "type": "facebook",
                "config": {
                    "appId": process.env.SAMPLE_FACEBOOK_APP_ID,
                    "appSecret": process.env.SAMPLE_FACEBOOK_APP_SECRET,
                    "successRedirect": "/index.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "autoRegister": true                    
                }
            },
            "twitter1": {
                "type": "twitter",
                "config": {
                    "consumerKey": process.env.SAMPLE_TWITTER_CONSUMER_KEY,
                    "consumerSecret": process.env.SAMPLE_TWITTER_CONSUMER_SECRET,
                    "successRedirect": "/index.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "autoRegister": true                     
                }
            },
            "linkedin1": {
                "type": "linkedin",
                "config": {
                    "apiKey": process.env.SAMPLE_LINKEDIN_API_KEY,
                    "apiSecret": process.env.SAMPLE_LINKEDIN_API_SECRET,
                    "successRedirect": "/index.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "autoRegister": true                     
                }
            }
        }
    }
});
