var server = require("cloudcms-server/server");

// report
server.report(function(callback) {

    console.log("");
    console.log("Cloud CMS Application Server #2 running on port: " + process.env.PORT);
    console.log("");

    callback();
});

// ensures that browser does not cache
server.routes(function(app, callback) {
    app.set('etag', false);
    app.use(function(req, res, next) {
        res.set("cache-control", "no-cache, no-store, must-revalidate");
        res.set("pragma", "no-cache");
        res.set("expires", 0);
        next();
    });
    callback();
});

// start the server
server.start({
    "setup": "cluster",
    "broadcast": {
        "enabled": true,
        "type": "redis",
        "config": {
            "port": 6379,
            "endpoint": "redis"
        }
    },
    "cache": {
        "type": "redis",
        "config": {
            "port": 6379,
            "endpoint": "redis"
        }
    }
});